/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.deploy.DeployPlugin;
import com.aptana.deploy.IDeployProvider;
import com.aptana.deploy.preferences.DeployPreferenceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployProviderRegistry {
    private static final String PROVIDER_ID_ATTRIBUTE = "id";
    private static final String PROVIDER_ELEMENT_NAME = "provider";
    private static final String DEPLOY_PROVIDERS_EXP_PT = "deployProviders";
    private Map<String, IConfigurationElement> providersById;
    private static DeployProviderRegistry fgInstance;

    private DeployProviderRegistry() {
    }

    public static synchronized DeployProviderRegistry getInstance() {
        if (fgInstance == null) {
            fgInstance = new DeployProviderRegistry();
        }
        return fgInstance;
    }

    public IDeployProvider getProvider(IContainer container) {
        IDeployProvider provider = this.getConfiguredProvider(container);
        if (provider == null) {
            Collection<IDeployProvider> providers = this.getAllProviders();
            for (IDeployProvider aProvider : providers) {
                if (!aProvider.handles(container)) continue;
                provider = aProvider;
                break;
            }
        }
        return provider;
    }

    private IDeployProvider getConfiguredProvider(IContainer container) {
        String id = DeployPreferenceUtil.getDeployProviderId(container);
        if (id == null) {
            return null;
        }
        return this.getProviderById(id);
    }

    private IDeployProvider createProvider(IConfigurationElement element) throws CoreException {
        return (IDeployProvider)element.createExecutableExtension("class");
    }

    private Collection<IDeployProvider> getAllProviders() {
        ArrayList<IDeployProvider> providers = new ArrayList<IDeployProvider>();
        for (IConfigurationElement element : this.providersById().values()) {
            try {
                providers.add(this.createProvider(element));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)DeployPlugin.getDefault(), (Throwable)e);
            }
        }
        return providers;
    }

    private synchronized Map<String, IConfigurationElement> providersById() {
        if (this.providersById == null) {
            this.providersById = new HashMap<String, IConfigurationElement>();
            try {
                IConfigurationElement[] elements;
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(DeployPlugin.getPluginIdentifier(), DEPLOY_PROVIDERS_EXP_PT);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    if (PROVIDER_ELEMENT_NAME.equals(element.getName())) {
                        String providerId = element.getAttribute(PROVIDER_ID_ATTRIBUTE);
                        this.providersById.put(providerId, element);
                    }
                    ++n2;
                }
            }
            catch (InvalidRegistryObjectException e) {
                IdeLog.logError((Plugin)DeployPlugin.getDefault(), (Throwable)e);
            }
        }
        return this.providersById;
    }

    public IDeployProvider getProviderById(String id) {
        if (id == null) {
            return null;
        }
        IConfigurationElement element = this.providersById().get(id);
        if (element != null) {
            try {
                return this.createProvider(element);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)DeployPlugin.getDefault(), (Throwable)e);
            }
        }
        return null;
    }

    public String getIdForProvider(IDeployProvider provider) {
        if (provider == null) {
            return null;
        }
        String className = provider.getClass().getName();
        for (Map.Entry<String, IConfigurationElement> entry : this.providersById().entrySet()) {
            if (!className.equals(entry.getValue().getAttribute("class"))) continue;
            return entry.getKey();
        }
        return null;
    }
}

